(function() {
  //    FILE:EventSheetView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'jqueryui/datepicker', 'models/bookingstructures/BookingstructuresModel', 'collections/event/EventCollection', 'models/time/TimeModel', 'models/objects/ObjectModel', 'views/event/EventView', 'views/request/AddRequestView', 'views/menu/MenuView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, DatePicker, BookingstructuresModel, EventCollection, TimeModel, ObjectModel, EventView, AddRequestView, MenuView) {
    var EventSheetView;
    return EventSheetView = class EventSheetView extends Backbone.View {
      initialize(usr, eventsCol, obj1) {
        this.usr = usr;
        this.eventsCol = eventsCol;
        this.obj = obj1;
        this.eventsCol.on('create', this.__update_events_sheet, this);
        this.eventsCol.on('change', this.__update_events_sheet, this);
        this.bookingStructures = new BookingstructuresModel();
        this.bookingStructures.get_booking_structures(this.usr);
        this.dayToShow = Moment();
        this.time = new TimeModel();
        this.viewable = this.usr.__can_view_event_in_time_frame(this.dayToShow);
        return this.bookable = this.usr.__can_create_event_in_time_frame(this.dayToShow);
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'EventSheetView'
        };
      }

      events() {
        return {
          'tap #id-btn-datepicker': 'btnDatePickerClicked',
          'tap #id-btn-datepicker-tomorrow': 'btnTomorrowClicked',
          'tap #id-btn-datepicker-yesterday': 'btnYesterdayClicked',
          //EVENT CLICKED
          'tap td.name': 'btnObjectClicked',
          'tap .div-event': 'btnEventClicked',
          //Click back => OBJECT VIEWINIG
          'tap #id-btn-backToObject': 'btnBackToObjectsClicked',
          'tap .div-slider-width  a': 'btnSetWidthChanged'
        };
      }

      render() {
        var previousView, template;
        //@$el.empty()
        template = Handlebars.templates['EventSheetView'];
        previousView = 'none';
        if (this.obj) {
          previousView = this.obj.get('previousView');
        }
        this.$el.html(template({
          user: this.usr.toJSON(),
          dayToShow: this.dayToShow.format('Do MMM'),
          previousView: previousView
        }));
        this.$el.attr('id', 'id-EventSheetView');
        this.$el.find('#id-h1-navbar-title').text(this.obj.get('objectName'));
        this.addSidePanel();
        return this.$el;
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      //# END OF HANDLING NAVIGATION

        //DATE SELECTOR
      btnTomorrowClicked(event) {
        var tomorrow;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        tomorrow = this.dayToShow.add('days', 1);
        this.dayToShow = tomorrow;
        this.viewable = this.usr.__can_view_event_in_time_frame(tomorrow);
        this.bookable = this.usr.__can_create_event_in_time_frame(tomorrow);
        $('#id-btn-datepicker .ui-btn-text').text(tomorrow.format('Do MMM'));
        this.eventsCol.get_day_events(this.usr, tomorrow.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnYesterdayClicked(event) {
        var yesterday;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        yesterday = this.dayToShow.subtract('days', 1);
        this.dayToShow = yesterday;
        this.viewable = this.usr.__can_view_event_in_time_frame(yesterday);
        this.bookable = this.usr.__can_create_event_in_time_frame(yesterday);
        $('#id-btn-datepicker .ui-btn-text').text(yesterday.format('Do MMM'));
        this.eventsCol.get_day_events(this.usr, yesterday.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnDatePickerClicked(event) {
        var firstDay, selDate, that;
        event.preventDefault();
        event.stopPropagation();
        that = this;
        selDate = new Date(this.dayToShow.format('YYYY-MM-DD'));
        if (!this.usr.get('weekStartsOnSunday')) {
          firstDay = 1;
        } else {
          firstDay = 0;
        }
        $('#id-input-datepicker').datepicker({
          dateFormat: 'yy-mm-dd',
          firstDay: firstDay,
          maxDate: window.MAXDATE,
          onSelect: function(dateText, dtp) {
            $.mobile.loading('show');
            that.dayToShow = Moment(dateText, 'YYYY-MM-DD');
            that.viewable = that.usr.__can_view_event_in_time_frame(that.dayToShow);
            that.bookable = that.usr.__can_create_event_in_time_frame(that.dayToShow);
            $('#id-btn-datepicker .ui-btn-text').text(Moment(dateText).format('Do MMM'));
            that.eventsCol.get_day_events(that.usr, that.dayToShow, that.obj);
            return that.eventsCol.trigger('change');
          }
        });
        $('#id-input-datepicker').datepicker("option", "defaultDate", selDate);
        return $('#id-input-datepicker').datepicker('show');
      }

      btnEventClicked(event) {
        var btn, eventID, view;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        eventID = btn.attr('data-bookingID');
        event = this.eventsCol.findWhere({
          eventID: eventID
        });
        event.get_details_event(this.usr.get('sessionID'));
        this.bookingStructures.get_booking_structures(this.usr);
        if (!EventView) {
          EventView = require("views/event/EventView"); //MAKING SURE IS LOADED
        }
        view = new EventView(this.usr, this.bookingStructures, this.eventsCol, event, this.dayToShow, this.obj);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnObjectClicked(event) {
        var cur, obj, objID, objName, objType;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        objID = cur.attr('data-objectID');
        objName = cur.text();
        objID = cur.attr('data-objectID');
        objType = cur.attr('data-objectType');
        obj = new ObjectModel({
          previousView: 'objectBrowser'
        });
        obj.on('change', this.showEventList, this);
        /*
        Last true parameter is because we have the data locally storaged, and we dont need extra info from the detail_object call
        AVOIDING A NETWORK CALL
        */
        return obj.set_object_detail(this.usr, objName, objID, objType, '', true);
      }

      showEventList(objMdl) {
        var EventListView, ev, type, view;
        //### ASK FOR EVENTS TOO MISSING OBJECT ID CUSTOM
        if (!EventCollection) {
          EventCollection = require("collections/event/EventCollection");
        }
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        ev = new EventCollection();
        ev.set_day_events(this.usr, this.dayToShow, objMdl);
        type = objMdl.get('objectType');
        if (type === 'sharedEventsView' || type === 'objectClass' || type === 'smartEventsView' || type === 'allEvents') {
          view = new EventSheetView(this.usr, ev, objMdl);
        } else {
          view = new EventListView(this.usr, ev, objMdl, this.dayToShow);
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      __update_events_sheet(col) {
        var events, note, objects, tbl, that;
        this.$el.find("#id-spinner-all").hide();
        tbl = this.$el.find('#id-table-events');
        tbl.empty();
        that = this;
        if (col instanceof EventCollection) {
          events = col.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = col.get_dayNote(that.dayToShow);
          objects = col.get_eventSheetObjects();
        } else {
          events = this.eventsCol.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = this.eventsCol.get_dayNote(that.dayToShow);
          objects = this.eventsCol.get_eventSheetObjects();
        }
        //SORT BY INI TIME
        events.sort();
        if (note) {
          $('#id-p-dayNote').text(note.note);
          $('#id-p-dayNote').show();
        } else {
          $('#id-p-dayNote').hide();
        }
        if (!_.isArray(objects)) {
          objects = [objects];
        }
        if ((objects != null ? objects.length : void 0) > 0) {
          return _.each(objects, function(obj) {
            var evs, td, tr;
            tr = "<tr class=\"trEvent \"  >";
            tr += `<td class='name' data-objectID=\"${obj.objectID}\" data-objectType=\"${obj.objectType}\"><span>${obj.displayName}</span></td>`;
            td = "<td class='events'>";
            evs = _.sortBy(that.__get_events_for_object(JSON.parse(JSON.stringify(events)), obj.objectID), function(ev) {
              return ev.timeIn;
            });
            if (events.length > 0) {
              _.each(evs, function(ev) {
                var divEvent, eventID, involved, mH, sH, timeIn, type;
                //GATHER INFO OF EVENT
                eventID = ev.eventID;
                timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
                //timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'),10),parseInt(that.usr.get('usesAMPM'),10),parseFloat(ev.timeOut))
                type = ev.type;
                if (type === 'undisclosed') {
                  mH = type;
                } else {
                  mH = ev.mainHeader;
                  sH = ev.subHeader;
                }
                //STARTING DOM CREATION
                divEvent = `<div data-bookingID=\"${eventID}\" class='div-event'>`;
                if (ev.isAlldayEvent) {
                  divEvent += "<span class='timeEvent'>All Day</span>";
                } else {
                  //NOT SHOWING TIME OUT BECAUSE IT DOES NOT FIT (SAME iOS)
                  divEvent += `<span class='timeEvent'>${timeIn}</span>`;
                }
                if (type === 'request') {
                  divEvent += `<span class='request'>${mH}</span>`;
                } else {
                  involved = ev.involvedHeader;
                  if (involved) {
                    divEvent += `<span class='booking' >${mH}</span>`;
                    divEvent += `<span class='involved'>${involved}</span>`;
                  } else {
                    divEvent += `<span class='booking-no-involved' >${mH}</span>`;
                  }
                }
                divEvent += '<span class="fwi-arrow-right arrow-right"></span></div>';
                return td += `${divEvent}`;
              });
            }
            td += "</td>";
            tr += `${td}</tr>`;
            return tbl.append(tr);
          });
        }
      }

      //$('.slider-width-label').slider('enable')
      btnSetWidthChanged(event) {
        var actualWidth, btn, changeWidth, newWidth;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        changeWidth = parseInt(btn.attr('data-value'), 10);
        actualWidth = this.$el.find('.name span').width();
        if ((actualWidth === 80 && changeWidth === -40) || (actualWidth > 350 && changeWidth === 40)) {
          return;
        }
        newWidth = String(changeWidth + actualWidth) + 'px';
        return this.$el.find('.name span').css('width', newWidth);
      }

      __get_events_for_object(events, objID) {
        return _.where(events, {
          objectID: objID
        });
      }

      btnBackToObjectsClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
